#pragma once
#include "afxwin.h"

// CEncoding dialog

class CEncoding : public CPropertyPage
{
	DECLARE_DYNAMIC(CEncoding)

public:
	CEncoding();
	virtual ~CEncoding();
	virtual BOOL OnInitDialog();

// Dialog Data
	enum { IDD = IDD_ENCODINGPAGE };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	DECLARE_MESSAGE_MAP()

	afx_msg void OnBnClickedBtnMagstripeboxClr();
	afx_msg void OnBnClickedBtnRequestmagdata();
	afx_msg void OnBnClickedBtnReadmagdata();
	afx_msg void OnBnClickedBtnEncodemagstripe();
	afx_msg void OnBnClickedBtnReadmagstripe();
	afx_msg void OnCbnSelchangeErrorresponseCombo();
	afx_msg void OnCbnSelchangeEncodingtypeCombo();
	afx_msg void OnBnClickedTrack1Write();
	afx_msg void OnBnClickedTrack2Write();
	afx_msg void OnBnClickedTrack3Write();
	afx_msg void OnBnClickedActionget();
	afx_msg void OnBnClickedActionset();
	afx_msg void OnBnClickedBtnMagstart();
	afx_msg void OnBnClickedBtnReadmagtracks();
	afx_msg void OnBnClickedGetActionRadio();
	afx_msg void OnBnClickedSetActionRadio();

private:
	void DecodeMagData();
	void DisplayMagData();
	BOOL ActionIsGet();
	ID_RETURN GetMagStart(DWORD *pMagStart);
	void MagStartToMsgBox(DWORD MagStart, ID_READWRITE Action);
	void MagStartToControl(DWORD MagStart);
	void AddMagMessage(CString pMessage);
	void EnableGetSetControls(BOOL bControl);
	void DisplayEnduroMag(PID_MAGDATA MagData, int Tracks);
	void DisplayGeneration2Mag(PID_MAGDATA2 MagData, int Tracks);

	int EncodingAction;

	CMainSheet *Parent;
	CEdit MagMessage;
	CButton EncodeMagBtn;
	CButton ReadMagBtn;
	CComboBox EncodingType;
	CComboBox Coercivity;
	CButton Verify;
	CEdit Track1Data;
	CEdit Track2Data;
	CEdit Track3Data;
	CButton Track1Write;
	CButton Track2Write;
	CButton Track3Write;
	CStatic Track1DataLabel;
	CStatic Track2DataLabel;
	CStatic Track3DataLabel;
	CStatic JIS2DataLabel;
	CStatic BitsPerCharLabel;
	CStatic BitsPerInchLabel;
	CStatic ParityLabel;
	CStatic LRCLabel;
	CStatic Track1SettingsLabel;
	CStatic Track2SettingsLabel;
	CStatic Track3SettingsLabel;
	CComboBox BPC_T1;
	CComboBox BPC_T2;
	CComboBox BPC_T3;
	CComboBox BPI_T1;
	CComboBox BPI_T2;
	CComboBox BPI_T3;
	CComboBox PAR_T1;
	CComboBox PAR_T2;
	CComboBox PAR_T3;
	CComboBox LRC_T1;
	CComboBox LRC_T2;
	CComboBox LRC_T3;
	CEdit StartPosition;
	CSpinButtonCtrl StartPosition_Spin;
	CButton Track1Read;
	CButton Track2Read;
	CButton Track3Read;
	CButton MagStartBtn;
	CButton EncodingGet;
	CButton EncodingSet;
	CButton ReadMagTracksBtn;
	CStatic StartPositionLabel;
};
